"use client";
import { useState } from "react";

const ImportDataModal = ({ isOpen, onClose }) => {
  const [fileName, setFileName] = useState("Click to Select CSV File");

  const handleFileChange = (e) => {
    const file = e.target.files[0];
    if (file) {
      setFileName(file.name);
    } else {
      setFileName("Click to Select CSV File");
    }
  };

  return (
    isOpen && (
      <div className={`modal  import-data`}>
        <div className="modal-content modal-import">
          <img
            src="./assets/images/icons/modal-close.svg"
            className="modal-close-btn close-cross"
            onClick={onClose}
            alt="close"
          />
          <div className="modal-header">
            <div>
              <img src="./assets/images/icons/upload.svg" alt="upload" />
              <span>Import Staff Data</span>
            </div>
          </div>
          <div className="sample-file-wrapper">
            <span>
              <a href="">Download a sample CSV</a> to see an example of the
              required format
            </span>
          </div>
          <div className="upload-form">
            <div className="modal-upload-wrappper">
              <img
                src="./assets/images/icons/upload.svg"
                className="u-file-icon"
                alt="upload icon"
              />
              <label htmlFor="file-upload" className="btn-sm btn-outline">
                Add File
              </label>
              <input
                type="file"
                id="file-upload"
                onChange={handleFileChange}
                className="file-input"
              />
              <span className="upload-instructions">{fileName}</span>
            </div>
          </div>
          <div className="btns-wrapper-modal">
            <button
              className="btn btn-outline modal-close-btn"
              onClick={onClose}
            >
              Cancel
            </button>
            <button className="btn btn-filled">Import</button>
          </div>
        </div>
      </div>
    )
  );
};

export { ImportDataModal };
