"use client";

import Link from "next/link";
import { useRef, useEffect, lazy } from "react";
import { usePathname } from "next/navigation";

export const SideNav = ({ toggleNav, navOpen }) => {
  const pathname = usePathname();

  const navLinks = [
    {
      href: "/",
      icon: "/assets/images/icons/dashboard-icon.svg",
      label: "Dashboard",
    },
    {
      href: "/attendence",
      icon: "/assets/images/icons/accounts-icon.svg",
      label: "Attendance",
    },
    {
      href: "/staff",
      icon: "/assets/images/icons/funnel-icon.svg",
      label: "Staff",
    },
    {
      href: "/shift",
      icon: "/assets/images/icons/funnel-icon.svg",
      label : "Shift",
    },
    {
      href: "/payroll",
      icon: "/assets/images/icons/payroll-icon.svg",
      label: "PayRoll",
    },
    {
      href: "/report",
      icon: "/assets/images/icons/invoices-icon.svg",
      label: "Report",
    },
    {
      href: "/cashbook",
      icon: "/assets/images/icons/cashbook-icon.svg",
      label: "Cash Book",
    },
  ];

  const businessSwitchers = [
    {
      href: "/",
      icon: "/assets/images/icons/profile-switch-icon.svg",
      label: "Hexon Digital",
      active: true,
    },
    {
      href: "/",
      icon: "/assets/images/icons/profile-switch-icon.svg",
      label: "Microsols Technologies",
      active: false,
    },
  ];

  const navRef = useRef();

  useEffect(() => {
    if (navRef.current) {
      if (navOpen) {
        navRef.current.classList.add("open");
        navRef.current.classList.remove("close");
      } else {
        navRef.current.classList.add("close");
        navRef.current.classList.remove("open");
      }
    }
  }, [navOpen]);

  const isActive = (href) => {
    return pathname === href;
  };

  return (
    <aside className="side-navigation" ref={navRef}>
      <div>
        <img
          src="./assets/images/icons/arrow-left.svg"
          alt="arrow left"
          className="close-nav"
          onClick={toggleNav}
        />
        <div>
          {navLinks.map((link, index) => (
            <Link
              key={index}
              href={link.href}
              className={`nav-link ${isActive(link.href) ? "link-active" : ""}`}
            >
              <img src={link.icon} alt={`${link.label}-icon`} />
              <span>{link.label}</span>
            </Link>
          ))}
        </div>
        <div className="profile-switchers">
          <span>Switch Business</span>
          <div className="switches-wrapper">
            {businessSwitchers.map((business, index) => (
              <Link
                key={index}
                href={business.href}
                className="profile-switch-link"
              >
                <img src={business.icon} alt={`${business.label}-icon`} />
                <span className="truncate-name">{business.label}</span>
                {business.active && (
                  <span className="active-profile-badge">Active</span>
                )}
              </Link>
            ))}
          </div>
        </div>
      </div>

      <div className="footer-links-wrapper">
        <span className="divider">Info</span>
        <Link
          href="/add"
          className={`nav-link ${isActive("/add") ? "link-active" : ""}`}
        >
          <img src="./assets/images/icons/gear-icon.svg" alt="gear-icon" />
          <span>Settings</span>
        </Link>
        <Link
          href="/help"
          className={`nav-link ${isActive("/help") ? "link-active" : ""}`}
        >
          <img src="./assets/images/icons/help-icon.svg" alt="help-icon" />
          <span>Help</span>
        </Link>
      </div>
    </aside>
  );
};
